//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
// MDI.cpp : Definiuje zachowanie klas w aplikacji.
//

// Jest to cz biblioteki Microsoft Foundation Classes C++.
// Copyright (c) Microsoft Corporation. Wszystkie prawa zastrzeone.
//
// Poniszy kod rdowy powsta tylko w celu uzupenienia
// Microsoft Foundation Classes Reference i powizanej
// dokumentacji elektronicznej, jaka zostaa udostpniona wraz z bibliotek.
// Szczegowe informacji na temat produktu Microsoft Foundation Classes
// mona odnale w tej dokumentacji.

#include "stdafx.h"
#include "MDI.h"

#include "MainFrm.h"

#include "AssemblyDoc.h"
#include "AssemblyFrame.h"
#include "AssemblyView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMDIApp

BEGIN_MESSAGE_MAP(CMDIApp, CWinApp)
	//{{AFX_MSG_MAP(CMDIApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	//}}AFX_MSG_MAP
	// ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Tworzenie CMDIApp

CMDIApp::CMDIApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// Jedyny obiekt CMDIApp

CMDIApp theApp;

/////////////////////////////////////////////////////////////////////////////
// Inicjalizacja CMDIApp

BOOL CMDIApp::InitInstance()
{
	CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);

	// Rejestracja szablonw dokumentw aplikacji. Szablony dokumentw su 
	// jako poczenie midzy dokumentami, oknami i widokami.

	CMultiDocTemplate* pAssemblyTemplate = new CMultiDocTemplate(
		IDR_ASSEMBLYVIEW,
		RUNTIME_CLASS(CAssemblyDoc),
		RUNTIME_CLASS(CAssemblyFrame),
		RUNTIME_CLASS(CAssemblyView));
	AddDocTemplate(pAssemblyTemplate);

	// Utworzenie gwnego okna MDI Frame
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// Gwne okno zostao utworzone, a wic mona je wywietli i zaktualizowa.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// Okno dialogowe CAboutDlg uywane przez App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dane okna dialogowego
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// Wygenerowana przez ClassWizard funkcja wirtualna zastpuje
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // Obsuga DDX/DDV
	//}}AFX_VIRTUAL

// Implementacja
protected:
	//{{AFX_MSG(CAboutDlg)
		// Brak procedur obsugi wiadomoci
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// Brak procedur obsugi wiadomoci
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Polecenie uruchamiajce okno dialogowe
void CMDIApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// inne ustawienia globalne

/////////////////////////////////////////////////////////////////////////////
// Polecenia CMDIApp

void CMDIApp::OnFileOpen()
{
	// Przeszukuje list szablonw w celu odnalezienia typu dokumentu 
	// zawierajcego cig "AssemblyView".

	POSITION curTemplatePos = GetFirstDocTemplatePosition();

	while(curTemplatePos != NULL)
	{
		CDocTemplate* curTemplate =
			GetNextDocTemplate(curTemplatePos);
		CString str;
		curTemplate->GetDocString(str, CDocTemplate::docName);
		if(str == _T("AssemblyView"))
		{
			// szFilters to cig tekstowy zawierajcy dwa filtry nazwy pliku:
			TCHAR szFilters[]=
				_T("Pliki podzespow (*.exe)|*.exe|DLL (*.dll)|*.dll||");

			// Utworzenie okna dialogowego Open; domylne rozszerzenie nazwy pliku to ".exe".
			CFileDialog fd (TRUE, _T("exe"), _T("*.exe"),
				            OFN_FILEMUSTEXIST| OFN_HIDEREADONLY,
							szFilters, 0);
			if(fd.DoModal() == IDOK)
			{
				curTemplate->OpenDocumentFile(fd.GetPathName());
				return;
			}
		}
	}
	AfxMessageBox(IDS_NOASSEMBLYTEMPLATE);
}

int CMDIApp::ExitInstance()
{
	CoUninitialize();

	return CWinApp::ExitInstance();
}
